﻿Imports System.Math
''' <summary>
''' Form para editar as horas extras executadas por cada funcionário
''' </summary>
''' <remarks></remarks>
Public Class frmHorasExtras
    Dim intDiasTotaisMês As Integer
    Dim intDiasÚteis As Integer
    Dim strNúmeroFuncionário As String
    Dim sglValorHoraNormal As Single
    Dim bolFimLoad As Boolean = False ' Já terminou de carregar a form, form criada completamente
    ''' <summary>
    ''' Rotina executada quando a form é aberta.
    ''' Selecciona o dia actual e formata no calendário 
    ''' A seguir carrega os funcionários activos (para o mês do calendário)
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub frmHorasExtras_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            calMês.SelectDate(Today)
            subFormataCalendário(Today.Year, Today.Month)
            subRebuildArvore()
            txbNúmeroHorasExtras.Enabled = False
            txbPercentagem.Enabled = False
            txbValorHoraNormal.Enabled = False
            btnCorrigir.Visible = False
            btnGravar.Enabled = False
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            bolFimLoad = True
        End Try
    End Sub
    ''' <summary>
    ''' O utilizador escolheu um funcionário.
    ''' Carregamos os valores das horas extras guardadas.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub tvwFuncionários_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles tvwFuncionários.AfterSelect
        subCarregaValores()
    End Sub
    ''' <summary>
    ''' O utilizador escolheu uma linha da tabela.
    ''' Os dados dessa Linha são carregados para as caixas de texto.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub dgvHorasExtras_CellClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles dgvHorasExtras.CellClick
        subEditarValores()
    End Sub
    ''' <summary>
    ''' O utilizador escolheu uma linha da tabela.
    ''' Os dados dessa Linha são carregados para as caixas de texto.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub dgvHorasExtras_KeyDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles dgvHorasExtras.KeyDown
        subEditarValores()
    End Sub
    ''' <summary>
    ''' O utilizador escolheu uma linha da tabela.
    ''' Os dados dessa Linha são carregados para as caixas de texto.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub dgvHorasExtras_KeyUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles dgvHorasExtras.KeyUp
        subEditarValores()
    End Sub
    ''' <summary>
    ''' O utilizador escolheu uma linha da tabela.
    ''' Os dados dessa Linha são carregados para as caixas de texto.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub dgvHorasExtras_CellContentClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles dgvHorasExtras.CellContentClick
        subEditarValores()
    End Sub
    ''' <summary>
    ''' Vamos introduzir novos dados na tabela ou actualizar caso já existam
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnGravar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGravar.Click
        Try
            If funTestaValores() Then
                If funValoresEditados() Then
                    subGravarDados()
                    subGravarTotais()
                End If
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            subCarregaValores()
            subFormataTabela()
            subCalculaTotal()
        End Try
    End Sub
    ''' <summary>
    ''' O utilizador decidiu alterar o valor de hora normal, então fazemos o botão "Corrigir" visivel para ele poder voltar a trás
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub txbValorHoraNormal_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txbValorHoraNormal.TextChanged
        Try
            subComparaValorHoraNormal()
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' O utilizador decidiu corrigir o valor da hora normal para o calculado
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnCorrigir_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCorrigir.Click
        txbValorHoraNormal.Text = sglValorHoraNormal
        btnCorrigir.Visible = False
    End Sub
    ''' <summary>
    ''' O utilizador alterou a data (Mês e/ou Ano)
    ''' Formatamos o calendário de acordo com a nova data
    ''' Carregamos os dados do mesmo funcionário seleccionado para o novo mês seleccionado
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub calMês_MonthChanged(ByVal sender As System.Object, ByVal e As Pabo.Calendar.MonthChangedEventArgs) Handles calMês.MonthChanged
        Try
            If bolFimLoad Then
                subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
                subRebuildArvore()
                txbValorHoraNormal.Text = ""
                dgvHorasExtras.Rows.Clear()
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub

    ''' <summary>
    ''' Carrega todos os Funcionários guardados e organiza a árvore alfabéticamente
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subRebuildArvore()
        Try
            tvwFuncionários.Nodes.Clear()

            Dim strSelectSQL As String = "SELECT Nome FROM Funcionários WHERE "
            strSelectSQL += "AdmitidoEm<='" & calMês.ActiveMonth.Year.ToString() & calMês.ActiveMonth.Month.ToString("00") & System.DateTime.Now.DaysInMonth(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month).ToString() & "' AND "
            strSelectSQL += "(RescindiuAfirmativo='' OR "
            strSelectSQL += "(RescindiuAfirmativo<>'' AND "
            strSelectSQL += "RescindiuEm>='" & calMês.ActiveMonth.Year.ToString() & calMês.ActiveMonth.Month.ToString("00") & "01')) "
            strSelectSQL += "ORDER BY Nome ASC"

            Dim dsNome As New DataSet
            Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
            Dim daNome As New SqlDataAdapter(strSelectSQL, Settings.strSQLConnection)

            sqlConn.Open()
            daNome.Fill(dsNome, "Nome")
            sqlConn.Close()

            tvwFuncionários.BeginUpdate()
            Dim nodeRoot As TreeNode
            nodeRoot = New TreeNode
            nodeRoot.Text = "Funcionários"
            nodeRoot.Tag = "Funcionários"
            tvwFuncionários.Nodes.Add(nodeRoot)

            For Each RowFuncionário As DataRow In dsNome.Tables("Nome").Rows
                Dim nodeFuncionário As TreeNode
                nodeFuncionário = New TreeNode
                nodeFuncionário.Text = RowFuncionário("Nome").ToString.Trim
                nodeFuncionário.Tag = RowFuncionário("Nome").ToString.Trim
                nodeRoot.Nodes.Add(nodeFuncionário)
            Next
            tvwFuncionários.EndUpdate()
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            tvwFuncionários.ExpandAll()
        End Try
    End Sub
    ''' <summary>
    ''' Calcula o Total de horas para o Funcionário e Mês actual
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subCalculaTotal()
        Try
            txbTotal.Text = "0"
            For Each row As DataGridViewRow In dgvHorasExtras.Rows
                txbTotal.Text += Round(Convert.ToDecimal(dgvHorasExtras.Rows(row.Index).Cells("colSubTotal").Value), 2)
            Next
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Vamos gravar os dados na base de dados
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subGravarDados()
        Try
            Dim x As Integer

            For Each row As DataGridViewRow In dgvHorasExtras.Rows
                If row.Index <> -1 And Not row.IsNewRow Then
                    'IF EXISTS (SELECT * FROM Table1 WHERE Column1='SomeValue')
                    'UPDATE Table1 SET (...) WHERE Column1='SomeValue'
                    'Else
                    'INSERT INTO Table1 VALUES (...)
                    Dim strComandoSQL As String = "IF EXISTS (SELECT * FROM HorasExtras WHERE "
                    strComandoSQL += "NúmeroFuncionário='" & row.Cells(colNúmeroFuncionário.Index).Value.ToString & "' AND "
                    strComandoSQL += "Ano='" & Int(row.Cells(colAno.Index).Value) & "' AND "
                    strComandoSQL += "Mês='" & Int(row.Cells(colMês.Index).Value) & "' AND "
                    strComandoSQL += "Dia='" & Int(row.Cells(colDia.Index).Value) & "' AND "
                    strComandoSQL += "Percentagem=Convert(real," & row.Cells(colPercentagem.Index).Value.ToString.Replace(",", ".") & ") "
                    strComandoSQL += ") "
                    strComandoSQL += "UPDATE HorasExtras SET "
                    strComandoSQL += "NúmeroHoras=Convert(real," & row.Cells(colNúmeroHoras.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & "), "
                    strComandoSQL += "ValorHoraNormal=Convert(real," & row.Cells(colValorHoraNormal.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & ") "
                    strComandoSQL += "WHERE ("
                    strComandoSQL += "NúmeroFuncionário='" & row.Cells(colNúmeroFuncionário.Index).Value.ToString & "' AND "
                    strComandoSQL += "Ano='" & Int(row.Cells(colAno.Index).Value) & "' AND "
                    strComandoSQL += "Mês='" & Int(row.Cells(colMês.Index).Value) & "' AND "
                    strComandoSQL += "Dia='" & Int(row.Cells(colDia.Index).Value) & "' AND "
                    strComandoSQL += "Percentagem=Convert(real," & row.Cells(colPercentagem.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & ") "
                    strComandoSQL += ") "
                    strComandoSQL += "ELSE "
                    strComandoSQL += "INSERT HorasExtras  VALUES ("
                    strComandoSQL += "'" & row.Cells(colNúmeroFuncionário.Index).Value.ToString & "', "
                    strComandoSQL += "'" & Int(row.Cells(colAno.Index).Value) & "', "
                    strComandoSQL += "'" & Int(row.Cells(colMês.Index).Value) & "', "
                    strComandoSQL += "'" & Int(row.Cells(colDia.Index).Value) & "', "
                    strComandoSQL += "Convert(real," & row.Cells(colNúmeroHoras.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & "), "
                    strComandoSQL += "Convert(real," & row.Cells(colValorHoraNormal.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & "), "
                    strComandoSQL += "Convert(real," & row.Cells(colPercentagem.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & ")) "

                    Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
                    Dim execCommand As New SqlCommand(strComandoSQL, sqlConn)
                    sqlConn.Open()
                    x = execCommand.ExecuteNonQuery
                    sqlConn.Close()
                    sqlConn = Nothing
                    execCommand = Nothing
                    strComandoSQL = Nothing
                End If
            Next
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Vamos gravar os totais na base de dados
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subGravarTotais()
        Try
            Dim x As Integer

            'IF EXISTS (SELECT * FROM Table1 WHERE Column1='SomeValue')
            'UPDATE Table1 SET (...) WHERE Column1='SomeValue'
            'Else
            'INSERT INTO Table1 VALUES (...)
            Dim strComandoSQL As String = "IF EXISTS (SELECT * FROM TotalHorasExtras WHERE "
            strComandoSQL += "NúmeroFuncionário='" & dgvHorasExtras.Rows(0).Cells(colNúmeroFuncionário.Index).Value.ToString & "' AND "
            strComandoSQL += "Ano='" & Int(dgvHorasExtras.Rows(0).Cells(colAno.Index).Value) & "' AND "
            strComandoSQL += "Mês='" & Int(dgvHorasExtras.Rows(0).Cells(colMês.Index).Value) & "' AND "
            strComandoSQL += "Dia='" & Int(dgvHorasExtras.Rows(0).Cells(colDia.Index).Value) & "' "
            strComandoSQL += ") "
            strComandoSQL += "UPDATE TotalHorasExtras SET "
            strComandoSQL += "Total=Convert(real," & txbTotal.Text.Replace(",", ".") & ") "
            strComandoSQL += "WHERE ("
            strComandoSQL += "NúmeroFuncionário='" & dgvHorasExtras.Rows(0).Cells(colNúmeroFuncionário.Index).Value.ToString & "' AND "
            strComandoSQL += "Ano='" & Int(dgvHorasExtras.Rows(0).Cells(colAno.Index).Value) & "' AND "
            strComandoSQL += "Mês='" & Int(dgvHorasExtras.Rows(0).Cells(colMês.Index).Value) & "' AND "
            strComandoSQL += "Dia='" & Int(dgvHorasExtras.Rows(0).Cells(colDia.Index).Value) & "' "
            strComandoSQL += ") "
            strComandoSQL += "ELSE "
            strComandoSQL += "INSERT TotalHorasExtras  VALUES ("
            strComandoSQL += "'" & dgvHorasExtras.Rows(0).Cells(colNúmeroFuncionário.Index).Value.ToString & "', "
            strComandoSQL += "'" & Int(dgvHorasExtras.Rows(0).Cells(colAno.Index).Value) & "', "
            strComandoSQL += "'" & Int(dgvHorasExtras.Rows(0).Cells(colMês.Index).Value) & "', "
            strComandoSQL += "'" & Int(dgvHorasExtras.Rows(0).Cells(colDia.Index).Value) & "', "
            strComandoSQL += "Convert(real," & txbTotal.Text.Replace(",", ".") & ")) "

            Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
            Dim execCommand As New SqlCommand(strComandoSQL, sqlConn)
            sqlConn.Open()
            x = execCommand.ExecuteNonQuery
            sqlConn.Close()
            sqlConn = Nothing
            execCommand = Nothing
            strComandoSQL = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' copia os valores da linha da tabela seleccionada para as caixas de texto a fim de serem editados
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subEditarValores()
        Try
            txbNúmeroHorasExtras.Enabled = False
            txbPercentagem.Enabled = False
            txbValorHoraNormal.Enabled = False
            txbNúmeroHorasExtras.Text = ""
            txbPercentagem.Text = ""
            txbValorHoraNormal.Text = ""
            btnCorrigir.Visible = False
            ' btnEliminar.Enabled = False (Este botão foi eliminado nesta fase)
            btnGravar.Enabled = False
            If dgvHorasExtras.CurrentRow.Index <> -1 And Not dgvHorasExtras.CurrentRow.IsNewRow Then
                Dim dtDias As DateTime = New DateTime(Int(dgvHorasExtras.CurrentRow.Cells(colAno.Index).Value), Int(dgvHorasExtras.CurrentRow.Cells(colMês.Index).Value), Int(dgvHorasExtras.CurrentRow.Cells(colDia.Index).Value))
                calMês.SelectDate(dtDias)
                txbNúmeroHorasExtras.Text = dgvHorasExtras.CurrentRow.Cells(colNúmeroHoras.Index).Value
                txbPercentagem.Text = dgvHorasExtras.CurrentRow.Cells(colPercentagem.Index).Value * 100
                txbValorHoraNormal.Text = dgvHorasExtras.CurrentRow.Cells(colValorHoraNormal.Index).Value
                sglValorHoraNormal = Convert.ToSingle(txbValorHoraNormal.Text)
                txbNúmeroHorasExtras.Enabled = True
                txbPercentagem.Enabled = True
                txbValorHoraNormal.Enabled = True
                ' btnEliminar.Enabled = True (Este botão foi eliminado nesta fase)
                btnGravar.Enabled = True
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' O utilizador já editou os valores, vamos enviar de novo para a tabela
    ''' </summary>
    ''' <returns>Retorna True se valores transferidos OK, False se falta alguma coisa</returns>
    ''' <remarks></remarks>
    Private Function funValoresEditados() As Boolean
        Try
            If calMês.SelectedDates.Count > 0 Then
                Dim intAno As Integer = calMês.SelectedDates(0).Year
                Dim intMês As Integer = calMês.SelectedDates(0).Month
                Dim intDia As Integer = calMês.SelectedDates(0).Day
                Dim sglNúmeroHorasExtras As Single = Convert.ToSingle(txbNúmeroHorasExtras.Text)
                Dim sglValorHoraNormal As Single = Convert.ToSingle(txbValorHoraNormal.Text)
                Dim sglPercentagem As Single = Convert.ToSingle(txbPercentagem.Text) / 100
                Dim sglSubTotal As Single = sglNúmeroHorasExtras * sglValorHoraNormal * (1.0 + sglPercentagem)

                If intAno = calMês.ActiveMonth.Year And intMês = calMês.ActiveMonth.Month Then
                    Dim bolNew As Boolean = True
                    For Each row As DataGridViewRow In dgvHorasExtras.Rows
                        If Not row.IsNewRow Then
                            If Int(dgvHorasExtras.Rows(row.Index).Cells(colAno.Index).Value) = intAno AndAlso Int(dgvHorasExtras.Rows(row.Index).Cells(colMês.Index).Value) = intMês AndAlso Int(dgvHorasExtras.Rows(row.Index).Cells(colDia.Index).Value) = intDia Then
                                dgvHorasExtras.Rows(row.Index).Cells(colNúmeroHoras.Index).Value = sglNúmeroHorasExtras
                                dgvHorasExtras.Rows(row.Index).Cells(colValorHoraNormal.Index).Value = sglValorHoraNormal
                                dgvHorasExtras.Rows(row.Index).Cells(colPercentagem.Index).Value = sglPercentagem
                                dgvHorasExtras.Rows(row.Index).Cells(colSubTotal.Index).Value = sglSubTotal
                                bolNew = False
                                Exit For
                            End If
                        End If
                    Next
                    If bolNew Then
                        dgvHorasExtras.Rows.Add(strNúmeroFuncionário, intAno, intMês, intDia, sglNúmeroHorasExtras, sglValorHoraNormal, sglPercentagem, sglSubTotal)
                    End If
                    Return True
                Else
                    MsgBox("Confirma por favor o dia seleccionado." & vbNewLine & "O dia seleccionado não pertence ao mês seleccionado, corriga o dia ou seleccione o mês correcto")
                    Return False
                End If
            Else
                MsgBox("Seleccione um dia por favor.")
                Return False
            End If
        Catch ex As Exception
            modLog.subErro(ex)
            Return False
        End Try
    End Function
    ''' <summary>
    ''' Preenchemos a tabela com as horas extras do funcionário e mês seleccionado
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subCarregaValores()
        Try
            dgvHorasExtras.Rows.Clear()
            txbNúmeroHorasExtras.Enabled = False
            txbPercentagem.Enabled = False
            txbValorHoraNormal.Enabled = False
            txbNúmeroHorasExtras.Text = ""
            txbPercentagem.Text = ""
            txbValorHoraNormal.Text = ""
            btnCorrigir.Visible = False
            ' btnEliminar.Enabled = False (Este botão foi eliminado nesta fase)
            btnGravar.Enabled = False

            For Each node As TreeNode In tvwFuncionários.Nodes(0).Nodes
                node.BackColor = Color.White
            Next
            If tvwFuncionários.SelectedNode.Tag <> "Funcionários" Then
                tvwFuncionários.SelectedNode.BackColor = Color.Aqua

                Dim strSelectSQL As String = "SELECT * FROM Funcionários, HorasExtras WHERE "
                strSelectSQL += "Funcionários.NúmeroFuncionário = HorasExtras.NúmeroFuncionário AND "
                strSelectSQL += "HorasExtras.Ano = '" & Int(calMês.ActiveMonth.Year) & " 'AND "
                strSelectSQL += "HorasExtras.Mês = '" & Int(calMês.ActiveMonth.Month) & " 'AND "
                strSelectSQL += "Funcionários.Nome='" & tvwFuncionários.SelectedNode.Tag & "' "
                strSelectSQL += "ORDER BY HorasExtras.Dia ASC, HorasExtras.Percentagem ASC"

                Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
                Dim commandSelect As New SqlCommand(strSelectSQL, sqlConn)
                sqlConn.Open()

                ' Executa o comando colocando num SqlDataReader os resultados
                Dim readerFuncionário As SqlDataReader = commandSelect.ExecuteReader()
                ' Caso existam rows (linhas)

                If readerFuncionário.HasRows Then
                    ' Executa um ciclo nas linhas existentes mostrando o campo “username”
                    While readerFuncionário.Read()
                        Dim intAno As Integer = Int(readerFuncionário.Item("Ano").ToString.Trim)
                        Dim intMês As Integer = Int(readerFuncionário.Item("Mês").ToString.Trim)
                        Dim intDia As Integer = Int(readerFuncionário.Item("Dia").ToString.Trim)
                        Dim sglNúmeroHorasExtras As Single = Int(readerFuncionário.Item("NúmeroHoras").ToString.Trim)
                        sglValorHoraNormal = Convert.ToSingle(readerFuncionário.Item("ValorHoraNormal").ToString.Trim)
                        Dim sglPercentagem As Single = readerFuncionário.Item("Percentagem").ToString.Trim
                        Dim sglSubTotal As Single = sglNúmeroHorasExtras * sglValorHoraNormal * (sglPercentagem + 1.0)
                        dgvHorasExtras.Rows.Add(readerFuncionário.Item("NúmeroFuncionário").ToString.Trim, intAno, intMês, intDia, sglNúmeroHorasExtras, sglValorHoraNormal, sglPercentagem, sglSubTotal)
                        txbValorHoraNormal.Text = sglValorHoraNormal
                        strNúmeroFuncionário = readerFuncionário.Item("NúmeroFuncionário").ToString.Trim
                    End While
                Else
                    ' Não há horas extraordinárias calculadas para este funcionário
                    ' vamos calcular o valor da hora normal (para o utilizador não fazer asneira)

                    Dim strHoraNormalSQL As String = "SELECT * FROM Funcionários, Mês WHERE "
                    strHoraNormalSQL += "Funcionários.NúmeroFuncionário = Mês.NúmeroFuncionário AND "
                    strHoraNormalSQL += "Funcionários.Nome='" & tvwFuncionários.SelectedNode.Tag & "' AND "
                    strHoraNormalSQL += "Mês.Ano='" & Int(calMês.ActiveMonth.Year) & "' AND "
                    strHoraNormalSQL += "Mês.Mês='" & Int(calMês.ActiveMonth.Month) & "'"

                    Dim sqlConnHoras As New SqlConnection(Settings.strSQLConnection)
                    Dim commandHoras As New SqlCommand(strHoraNormalSQL, sqlConnHoras)
                    sqlConnHoras.Open()

                    ' Executa o comando colocando num SqlDataReader os resultados
                    Dim readerHoras As SqlDataReader = commandHoras.ExecuteReader()
                    ' Caso existam rows (linhas)

                    If readerHoras.HasRows Then
                        ' Executa um ciclo nas linhas existentes mostrando o campo “username”
                        While readerHoras.Read()
                            strNúmeroFuncionário = readerHoras.Item("NúmeroFuncionário").ToString.Trim
                            sglValorHoraNormal = Round(Convert.ToDecimal(readerHoras.Item("VencimentoBase").ToString.Trim) * 12 / Settings.intNúmeroHorasSemanais / 52, 2)
                            txbValorHoraNormal.Text = sglValorHoraNormal.ToString
                        End While
                    Else
                        Dim resposta As Integer = MsgBox("Ainda não foi preenchida a tabela relativa ao mês escolhido!", MsgBoxStyle.YesNo, "Quer editar os valores para o mês?")
                        If resposta = vbYes Then
                            Me.Hide()
                            frmMês.Show()
                            frmMês.Focus()
                        Else
                            strNúmeroFuncionário = ""
                        End If
                    End If

                    ' Fecha a ligação e limpa as variáveis
                    sqlConnHoras.Close()
                    sqlConnHoras = Nothing
                    commandHoras = Nothing
                End If

                ' Fecha a ligação e limpa as variáveis
                sqlConn.Close()
                sqlConn = Nothing
                commandSelect = Nothing
                If txbValorHoraNormal.Text <> "" Then
                    txbNúmeroHorasExtras.Enabled = True
                    txbPercentagem.Enabled = True
                    txbValorHoraNormal.Enabled = True
                    ' btnEliminar.Enabled = True (Este botão foi eliminado nesta fase)
                    btnGravar.Enabled = True
                End If
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            subFormataTabela()
            subCalculaTotal()
            subComparaValorHoraNormal()
        End Try
    End Sub
    ''' <summary>
    ''' Valida os valores introduzidos para não dar erro no envio para o SQL
    ''' </summary>
    ''' <returns>Retorna True se todos os dados estiverem correctos</returns>
    ''' <remarks></remarks>
    Private Function funTestaValores() As Boolean
        Try
            If IsNumeric(txbNúmeroHorasExtras.Text) Then
                If Convert.ToDecimal(txbNúmeroHorasExtras.Text) < 0 Then
                    MsgBox("O número de horas extras é negativo!")
                    Return False
                End If
                If Convert.ToDecimal(txbNúmeroHorasExtras.Text) > 24 Then
                    MsgBox("O número de horas extras é superior ao número de horas do dia (24 horas/dia)!")
                    Return False
                End If
            Else
                MsgBox("O valor do número de horas extras não é um número!")
                Return False
            End If
            If IsNumeric(txbPercentagem.Text) Then
                If Int(txbPercentagem.Text) < 0 Then
                    MsgBox("Valor da percentagem é negativa!")
                    Return False
                End If
            Else
                MsgBox("O valor da percentagem não é um número!")
                Return False
            End If
            If IsNumeric(txbValorHoraNormal.Text) Then
                If Convert.ToDecimal(txbValorHoraNormal.Text) < 0 Then
                    MsgBox("O valor de cada hora normal (€) é negativo!")
                    Return False
                End If
                If Convert.ToDecimal(txbValorHoraNormal.Text) <> sglValorHoraNormal Then
                    MsgBox("O valor de cada hora normal (" & txbValorHoraNormal.Text & " €) é diferente do valor calculado (" & sglValorHoraNormal.ToString & " €)!", MsgBoxStyle.Information, "Aviso")
                    ' Permito gravar na mesma, mas o utilizador é avisado
                    'Return False 
                End If
            Else
                MsgBox("O valor de cada hora normal (€) não é um número!")
                Return False
            End If

            Return True
        Catch ex As Exception
            modLog.subErro(ex)
            Return False
        End Try
    End Function
    ''' <summary>
    ''' Compara o valor da caixa de texto para hora normal, com o valor calculado, se for diferente põe visivel o botão para corrigir, caso o utilizador tenha alterado sem querer pode voltar a trás
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subComparaValorHoraNormal()
        Try
            If IsNumeric(txbValorHoraNormal.Text) Then
                If Convert.ToSingle(txbValorHoraNormal.Text) <> sglValorHoraNormal Then
                    btnCorrigir.Visible = True
                Else
                    btnCorrigir.Visible = False
                End If
            Else
                btnCorrigir.Visible = False
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub

    ''' <summary>
    ''' Formata o calendário mediante se é Sábado, Domingo ou Feriado
    ''' E calcula o nº total de dias do mês e nº total de dias úteis do mês
    ''' </summary>
    ''' <param name="Ano"></param>
    ''' <param name="Mês"></param>
    ''' <remarks></remarks>
    Private Sub subFormataCalendário(ByVal Ano As Integer, ByVal Mês As Integer)
        Try
            intDiasTotaisMês = 30 ' Para efeitos de segurança social, o mês tem sempre 30 daias System.DateTime.DaysInMonth(Ano, Mês)
            calMês.ResetDateInfo() ' Limpa as datas formatadas
            Dim dtData As DateTime = New DateTime(Ano, Mês, 1)
            Dim diaDatas As Pabo.Calendar.DateItem() = New Pabo.Calendar.DateItem(System.DateTime.DaysInMonth(Ano, Mês)) {}
            diaDatas.Initialize()
            For i As Integer = 1 To System.DateTime.DaysInMonth(Ano, Mês)
                diaDatas(i) = New Pabo.Calendar.DateItem()
                If funDiaFeriado(dtData) = "" Then
                    ' Não é Feriado
                    If dtData.DayOfWeek = DayOfWeek.Saturday Then
                        ' É sábado
                        diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                        diaDatas(i).BackColor1 = Color.LightBlue
                    ElseIf dtData.DayOfWeek = DayOfWeek.Sunday Then
                        ' É Domingo
                        diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                        diaDatas(i).BackColor1 = Color.OrangeRed
                    Else
                        ' Não é feriado e é dia útil
                        intDiasÚteis += 1
                    End If
                Else
                    ' É feriado
                    diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                    diaDatas(i).BackColor1 = Color.Orange
                End If
                dtData = dtData.AddDays(1) ' Passa para o próximo dia
            Next
            calMês.AddDateInfo(diaDatas)
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Formata a tabela
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subFormataTabela()
        Try
            dgvHorasExtras.Columns(colAno.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
            dgvHorasExtras.Columns(colMês.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
            dgvHorasExtras.Columns(colDia.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
            dgvHorasExtras.Columns(colNúmeroHoras.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
            dgvHorasExtras.Columns(colValorHoraNormal.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
            dgvHorasExtras.Columns(colValorHoraNormal.Index).DefaultCellStyle.Format = "#,##0.00 €"
            dgvHorasExtras.Columns(colPercentagem.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
            dgvHorasExtras.Columns(colPercentagem.Index).DefaultCellStyle.Format = "#,##0.0 %"
            dgvHorasExtras.Columns(colSubTotal.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
            dgvHorasExtras.Columns(colSubTotal.Index).DefaultCellStyle.Format = "#,##0.00 €"
            dgvHorasExtras.Sort(colDia, System.ComponentModel.ListSortDirection.Ascending)
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
End Class